/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.system.dto.MYakusyokuDto;

public class YakusyokuMasterListVo extends MosPVo {

	private static final long serialVersionUID = -751062849161954119L;

	// URLACSS
	private static final String RETURN_URL	= "/jsp/system/yakusyokuMasterList.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/yakusyokuMasterList.js";
	private static final String EXTRA_CSS		= "/pub/system/css/yakusyokuMasterList.css";	

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_POSITION_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_YCODE 		= "txtYCode";
	public static final String PRM_TXT_YNAME 		= "txtYName";
	public static final String PRM_PLT_TOKYU 		= "pltTokyu";

	// tB[h	
	private String[]	aryYCode;
	private String[]	aryTokyu;
	private String[]	aryTokyuName;
	private String[]	aryYName;
	private String 		txtYCode ;
	private String 		txtYName ;
	private String 		pltTokyu ;

	// tB[hyѐ
	public static final String NAM_YCODE	= CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_CODE ;
	public static final String NAM_TOKYU	= CommonConst.NAM_GRADE ;
	public static final String NAM_YNAME	= CommonConst.NAM_COMMON_MEISYO ;

	public static final int	LEN_YCODE	= 5;
	public static final int	LEN_YNAME	= 20;

	// v_EXg
	public String[][] aryPltTokyu;

	// \[gL[
	public final String KEY_YCODE		= "keyYCode";
	public final String KEY_TOKYU		= "keyTokyu";
	public final String KEY_YNAME		= "keyYName";

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public YakusyokuMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		aryYCode 		= new String[0];
		aryTokyu 		= new String[0];
		aryTokyuName 	= new String[0];
		aryYName 		= new String[0];
		txtYCode 		= "";
		txtYName 		= "";
		pltTokyu 		= "";
		setFormerKey(KEY_YCODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtYCode = request.getParameter(PRM_TXT_YCODE);
		txtYName = request.getParameter(PRM_TXT_YNAME);
		pltTokyu = request.getParameter(PRM_PLT_TOKYU);
	}

	/**
	 * tB[hݒ
	 * @param listPosition		EXg
	 */
	public void setFields(List listPosition) {
		// Xg̐ݒ
		list = listPosition;
		// f[^̎擾
		count = listPosition.size();
		// z̏
		aryYCode		= new String[count];
		aryYName		= new String[count];
		aryTokyu		= new String[count];
		aryTokyuName	= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listPosition.iterator();
		while (it.hasNext()) {
			MYakusyokuDto dto = (MYakusyokuDto)it.next();
			aryYCode[i] 	= escapeHTML(dto.getYCode());
			aryYName[i] 	= escapeHTML(dto.getYName());
			aryTokyu[i] 	= escapeHTML(dto.getTokyu());
			aryTokyuName[i] = escapeHTML(util.getCodeName(dto.getTokyu(), aryPltTokyu));
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh	
	public String[] getEscAryYCode() 		{ return aryYCode.clone(); }
	public String[] getEscAryTName() 		{ return aryYName.clone(); }
	public String[] getEscAryTokyu() 		{ return aryTokyu.clone(); }
	public String[] getEscAryTokyuName() 	{ return aryTokyuName.clone(); }

	public String getTxtYCode() { return txtYCode; }
	public String getTxtYName() { return txtYName; }
	public String getPltTokyu() { return pltTokyu; }	

	public String getEscTxtYCode() { return escapeHTML(txtYCode); }
	public String getEscTxtYName() { return escapeHTML(txtYName); }
	public String getEscPltTokyu() { return escapeHTML(pltTokyu); }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
